/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
draw_occupant_images();

/**
 * Draw occupant body region scoring indicator images for the specified models
 */
function draw_occupant_images() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let output_dir = get_expanded_variable_value(templ, `OUTPUT_DIR`);
    if (!output_dir) {
        LogError(`Could not find OUTPUT_DIR variable for writing occupant image files.`);
        return;
    } else if (!File.IsDirectory(output_dir)) {
        LogError(`OUTPUT_DIR is not a valid directory: ${output_dir}`);
        return;
    }

    let occupants = ["DRIVER", "REAR_DRIVER_SIDE"];
    for (let m of models) {
        for (let occ of occupants) {
            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            let head_score = get_variable_value(status, `${m}_${occ}_HEAD_FINAL_SCORE`, "float");
            let chest_score = get_variable_value(status, `${m}_${occ}_CHEST_FINAL_SCORE`, "float");
            let abdomen_score = get_variable_value(status, `${m}_${occ}_ABDOMEN_FINAL_SCORE`, "float");
            let pelvis_score = get_variable_value(status, `${m}_${occ}_PELVIS_FINAL_SCORE`, "float");

            if (!status.success) {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} body region score indicator images`);
            }

            /* Create new image */
            let img = new Image(320, 350);
            img.lineWidth = 1;
            img.lineColour = "black";
            let steering_colour = "#000000";
            /* Draw the body regions */

            /* coloured in regions*/
            if (occ == "DRIVER") {
                draw_left_side_view_head(img, get_fill_colour_CNCAP(head_score));
                draw_left_side_view_chest(img, get_fill_colour_CNCAP(chest_score));
                draw_left_side_view_abdomen(img, get_fill_colour_CNCAP(abdomen_score));
                draw_left_side_view_pelvis(img, get_fill_colour_CNCAP(pelvis_score));
                draw_left_side_view_left_arm(img, get_fill_colour_CNCAP(null));
            } else {
                draw_left_side_view_head(img, get_fill_colour_CNCAP(head_score, 1));
                draw_left_side_view_chest(img, get_fill_colour_CNCAP(chest_score, 1));
                draw_left_side_view_abdomen(img, get_fill_colour_CNCAP(abdomen_score, 1));
                draw_left_side_view_pelvis(img, get_fill_colour_CNCAP(pelvis_score, 1));
                draw_left_side_view_left_arm_occupant(img);
            }

            /*Not coloured in regions*/
            draw_left_side_view_neck(img, get_fill_colour_CNCAP(null));
            draw_left_side_view_left_leg(img, get_fill_colour_CNCAP(null));

            if (occ == "DRIVER") {
                draw_left_side_view_steering_wheel(img, steering_colour);
            }
            LogPrint(`dummy image is saved to this name ${output_dir}/${m}_${occ.toLowerCase()}_plot.png`);
            img.Save(`${output_dir}/${m}_${occ.toLowerCase()}_plot.png`, Image.PNG);
        }
    }
}
